//
//  GSTransformGrid.h
//  GlyphsPaletteTransform
//
//  Created by Georg Seifert on 22.01.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class GSTransformGrid;

@protocol GSTransformGridDataSource
- (void)transformGrid:(GSTransformGrid *)transformGrid didChangeSelectedCorner:(NSInteger)selectedCorner;
- (NSUInteger)selectedCornerForTransformGrid:(GSTransformGrid *)transformGrid;
@end

@interface GSTransformGrid : NSButton
@property () NSObject<GSTransformGridDataSource> *dataSource;
@property (nonatomic) NSInteger selectedCorner;
@property (nonatomic) BOOL selected;
@end
